unit FormOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, ActnList, Buttons, SqlExpr;

type
  TFOsoby = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    ListView: TListView;
    SpeedButton1: TSpeedButton;
    sbInsert: TSpeedButton;
    sbEdit: TSpeedButton;
    sbDelete: TSpeedButton;
    ActionList1: TActionList;
    ActionClose: TAction;
    ActionInsert: TAction;
    ActionEdit: TAction;
    ActionDelete: TAction;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure ActionCloseExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ActionInsertExecute(Sender: TObject);
    procedure ActionEditExecute(Sender: TObject);
    procedure ActionDeleteExecute(Sender: TObject);
    procedure ListViewKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private

  public
    procedure Pokaz_osoby();

    procedure My_insert();
    procedure My_edit();
    procedure My_delete();

    constructor Create(AOwner: TComponent); override;
  end;

var
  FOsoby: TFOsoby;

implementation

uses DataModule, DialogOsoba;
{$R *.dfm}
{------------------------------------------------------------------------------}
constructor TFOsoby.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   FOsoby := NIL;
end;

procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFOsoby.FormShow(Sender: TObject);
begin
   pokaz_osoby();
end;

procedure TFOsoby.ActionInsertExecute(Sender: TObject);
begin
   my_insert();
end;

procedure TFOsoby.ActionEditExecute(Sender: TObject);
begin
   my_edit();
end;

procedure TFOsoby.ActionDeleteExecute(Sender: TObject);
begin
   my_delete();
end;

procedure TFOsoby.ListViewKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if Key = VK_INSERT then begin
      my_insert();
   end;

   if Key = VK_RETURN then begin
      my_edit();
   end;

   if Key = VK_DELETE then begin
      my_delete();
   end;
end;

procedure TFOsoby.My_edit();
var
   Res  : TModalResult;  // bada w jaki sposb zostao zamkniete okno dialogowe
   ilel : Integer;       // ilo elementw w ListView

begin
   // edycja ma sens jeeli lista nie jest pusta
   ilel := ListView.Items.Count;
   if ilel = 0 then begin
      EXIT;
   end;

   try
      DlgOsoba := TDlgOsoba.Create(Self, True, ListView);
      res      := DlgOsoba.ShowModal();

      if res = mrOK then begin
         ListView.Visible := False;
         ListView.Items.Clear();

         Pokaz_osoby();

         ListView.Visible := True;
      end;
   finally
      FreeAndNil(DlgOsoba);
      ListView.SetFocus();
   end;
end;

procedure TFOsoby.My_insert();
var
   Res : TModalResult;

begin
   try
      DlgOsoba := TDlgOsoba.Create(Self, False, ListView);
      res      := DlgOsoba.ShowModal();

      if res = mrOK then begin
         ListView.Visible := False;

         ListView.Items.Clear();

         Pokaz_osoby();

         ListView.Visible := True;
      end;
   finally
      FreeAndNil(DlgOsoba);
      ListView.SetFocus();
   end;
end;

procedure TFOsoby.My_delete();
var
   TD      : TTransactionDesc;
   ilel    : integer;
   poz     : integer;
   idosoby : Integer;

begin
   // edycja ma sens jeeli lista nie jest pusta
   ilel := ListView.Items.Count;
   if ilel = 0 then begin
      EXIT;
   end;

   if MessageBox(0, PChar('Usun rekord ?'), 'Ostrzeenie', MB_YESNO ) = IDYES then begin
      idosoby := StrToInt(ListView.Selected.SubItems[0]);
      try
         try
            if not DM.SQLConnection.InTransaction then begin
               TD.TransactionID  := 1;
               TD.IsolationLevel := xilREADCOMMITTED;

               DM.SQLConnection.StartTransaction(TD);
               DM.SQLDataSetDelete.ParamByName('IDOSOBY').AsInteger := idosoby;
               DM.SQLDataSetDelete.ExecSQL();
               DM.SQLConnection.Commit(TD);

               ListView.Visible := False;
               ListView.Items.Clear();
               pokaz_osoby();
               ListView.Visible := True;

               ModalResult := mrOK;
            end
            else begin
               ShowMessage('InTransaction');
            end;
         except
            DM.SQLConnection.Rollback(TD);
            ShowMessage('Rollback');
         end;
      finally
         DM.SQLDataSetDelete.Close();
         ListView.SetFocus();
      end;
   end
end;

procedure TFOsoby.Pokaz_osoby();
var
   i         : Integer;
   Lp        : Integer;
   ListItem  : TListItem;

begin
   DM.SQLDataSet.Open();

   with ListView do begin
      Lp := 0;

      with DM do begin
         while not SQLDataSet.EOF do begin
            Inc(lp);

            ListItem := items.Add;

            // uwaga: do pierwszej kolumny mozna si odwoa przez Caption
            ListItem.Caption := IntToStr(Lp);

            // Nastpne kolumny uzyskujemy poprzez SubItems[0,1,2,...]
            ListItem.SubItems.Add(SQLDataSet.FieldValueS['IDOSOBY']);
            ListItem.SubItems.Add(SQLDataSet.FieldValueS['NAZWISKO']);
            ListItem.SubItems.Add(SQLDataSet.FieldValueS['IMIE']);
            ListItem.SubItems.Add(SQLDataSet.FieldValueS['DATAUR']);
            ListItem.SubItems.Add(SQLDataSet.FieldValueS['MCOWOSC']);
            ListItem.SubItems.Add(SQLDataSet.FieldValueS['ULICAINR']);
            ListItem.SubItems.Add(SQLDataSet.FieldValueS['KODP']);
            ListItem.SubItems.Add(SQLDataSet.FieldValueS['MIASTO']);
            ListItem.SubItems.Add(SQLDataSet.FieldValueS['PESEL']);

            SQLDataSet.Next();
         end;
      end;
   end;

   DM.SQLDataSet.Close();
end;

end.

